% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Huber.R
\name{huber.lasso}
\alias{huber.lasso}
\title{Huber-Lasso estimator}
\usage{
huber.lasso(y, X, beta.ini, lambda, alpha = 2, adaptive = T,
  intercept = FALSE)
}
\arguments{
\item{y}{response vector.}

\item{X}{design matrix, standardization is recommended.}

\item{beta.ini}{initial estimates of beta. Using unpenalized Huber or LAD is recommended under high-dimensional setting.}

\item{lambda}{regularization parameter of Lasso or adaptive Lasso (if adaptive=TRUE).}

\item{alpha}{1/alpha is the huber tuning parameter. Larger alpha results in smaller portion of squared loss.}

\item{adaptive}{logical input that indicates if adaptive Lasso is used. Default is TRUE.}

\item{intercept}{logical input that indicates if intercept needs to be estimated. Default is FALSE.}
}
\value{
\item{beta}{the regression coefficient estimates.}
\item{fitted}{predicted response.}
\item{iter.steps}{iteration steps.}
}
\description{
This function is L1 penalized Huber estimator for linear regression under both fixed and high-dimensional settings.
Currently, the function does not support automatic selection of huber tuning parameter.
}
\examples{
set.seed(2017)
n=200; d=50
X=matrix(rnorm(n*d), nrow=n, ncol=d)
beta=c(rep(2,6), rep(0, 44))
y=X\%*\%beta+c(rnorm(150), rnorm(30,10,10), rnorm(20,0,100))
output.HuberLasso=huber.lasso(y,X, beta.ini=LAD(y, X), lambda=0.2, adaptive=TRUE)
beta.est=output.HuberLasso$beta

}
