% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{EvaluatePopulation}
\alias{EvaluatePopulation}
\title{Evaluate objective value of a set of individuals}
\usage{
EvaluatePopulation(pop, fun, ...)
}
\arguments{
\item{pop}{The population to be evaluated}

\item{fun}{A string containing which problem is being solved. Currently available in the package: DTLZ1-DTLZ4, WFG4-WFG9.}

\item{...}{Further parameters used by \code{fun}}
}
\value{
A matrix of size nObjective, containing the objective values.
}
\description{
Evaluate a population with the specified test function. Non-feasible solution are given Inf as objective values.
}
\examples{
pop <- matrix(runif(8*50),nrow=8) # 8 variables, 50 individuals
EvaluatePopulation(pop,WFG4,3) # the 3 is passed to WFG4 nObj
}
