% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CART.R
\name{CART}
\alias{CART}
\title{Fit and graph a cart model}
\usage{
CART(formula, data, p = 0.7, nodes_min = 2, nodes_max = 18,
  includedata = FALSE, seed = NULL, ...)
}
\arguments{
\item{formula}{a formula of the form y ~ x1 + x2 + ...}

\item{data}{the data frame that contains the variables specified in \code{formula}.}

\item{p}{the percentage of the training dataset to be obtained randomly.}

\item{nodes_min}{Number of minimum nodes.}

\item{nodes_max}{Number of maximum nodes.}

\item{includedata}{logicals. If TRUE the training and testing datasets are returned.}

\item{seed}{a single value, interpreted as an integer, or NULL. The default value is NULL, but for future checks of the model or models generated it is advisable to set a random seed to be able to reproduce it.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A MLA object of subclass CART
}
\description{
Classification And Regression Tree is a simple technique to fit a relationship between numerical variables partitioning the target variable by a range of values of the explanatory variables. This function fits and graphs a cart model with a previous separation of training a testing datasets.
}
\examples{
## Load a Dataset
 \dontrun{
data(EGATUR)
CART(GastoTotalD~pais+aloja+motivo,data=EGATUR)
}

}
