% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AssociationRules.R
\name{AssociationRules}
\alias{AssociationRules}
\title{Simple way to obtain data mining rules}
\usage{
AssociationRules(data, support = 0.2, confidence = 0.1,
  minlength = 2)
}
\arguments{
\item{data}{a data frame with discrete variables.}

\item{support}{a numeric value for the minimun support of the antecedents (default: 0.2).}

\item{confidence}{a numeric value for the minimun confidence of confidence in rule/association method (default: 0.8)}

\item{minlength}{an integer value for the minimal number of items per item set (default: 2 item)}
}
\value{
A MLA object of subclass Association
}
\description{
This is a rule-based machine learning method to discover interesting relationships between a consequent and an antecedent (or group of antecedents) in large databases.
}
\examples{
## Load a Dataset
data(EGATUR)
## Generate an asociation rules with apriori, remmember only support discretized variables,
##  in this remove numerical variables.
Rules <- AssociationRules(EGATUR[,c(2,4,5,8)])

}
