% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary}
\alias{summary}
\alias{summary.ModelMetrics}
\alias{summary.Resamples}
\alias{summary.MLModelTune}
\alias{summary.Confusion}
\alias{summary.ConfusionMatrix}
\title{Model Performance Summary}
\usage{
\method{summary}{ModelMetrics}(object, stats = c(Mean = base::mean,
  Median = stats::median, SD = stats::sd, Min = base::min, Max =
  base::max), na.rm = TRUE, ...)

\method{summary}{Resamples}(object, stats = c(Mean = base::mean, Median =
  stats::median, SD = stats::sd, Min = base::min, Max = base::max),
  na.rm = TRUE, ...)

\method{summary}{MLModelTune}(object, stats = c(Mean = base::mean, Median
  = stats::median, SD = stats::sd, Min = base::min, Max = base::max),
  na.rm = TRUE, ...)

\method{summary}{Confusion}(object, ...)

\method{summary}{ConfusionMatrix}(object, ...)
}
\arguments{
\item{object}{object to summarize.}

\item{stats}{function, one or more function names, or list of named functions
to include in the calculation of summary statistics.}

\item{na.rm}{logical indicating whether to exclude missing values.}

\item{...}{arguments passed to other methods.}
}
\value{
array with summmary statistics in the second dimension, metrics in
the first for single models, and models and metrics in the first and third,
respectively, for multiple models.
}
\description{
Summary statistics for resampled model performance metrics.
}
\examples{
## Factor response example

fo <- Species ~ .
control <- CVControl()

gbmres1 <- resample(fo, iris, GBMModel(n.trees = 25), control)
gbmres2 <- resample(fo, iris, GBMModel(n.trees = 50), control)
gbmres3 <- resample(fo, iris, GBMModel(n.trees = 100), control)
summary(gbmres3)

res <- Resamples(GBM1 = gbmres1, GBM2 = gbmres2, GBM3 = gbmres3)
summary(res)

}
\seealso{
\code{\link{modelmetrics}}, \code{\link{resample}},
\code{\link{diff}}, \code{\link{tune}}, \code{\link{confusion}}
}
