% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_POLRModel.R
\name{POLRModel}
\alias{POLRModel}
\title{Ordered Logistic or Probit Regression Model}
\usage{
POLRModel(method = c("logistic", "probit", "loglog", "cloglog",
  "cauchit"))
}
\arguments{
\item{method}{logistic or probit or (complementary) log-log or cauchit
(corresponding to a Cauchy latent variable).}
}
\value{
\code{MLModel} class object.
}
\description{
Fit a logistic or probit regression model to an ordered factor response.
}
\details{
\describe{
\item{Response Types:}{\code{ordered}}
}

Further model details can be found in the source link below.
}
\examples{
library(MASS)

df <- Boston
df$medv <- cut(Boston$medv, breaks = c(0, 15, 20, 25, 50), ordered = TRUE)   
fit(medv ~ ., data = df, model = POLRModel())

}
\seealso{
\code{\link[MASS]{polr}}, \code{\link{fit}}, \code{\link{resample}},
\code{\link{tune}}
}
