% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{performance}
\alias{performance}
\alias{performance.factor}
\alias{performance.matrix}
\alias{performance.numeric}
\alias{performance.Surv}
\alias{performance.Confusion}
\alias{performance.ConfusionMatrix}
\alias{performance.Resamples}
\title{Model Performance Metrics}
\usage{
performance(x, ...)

\method{performance}{factor}(x, y,
  metrics = MachineShop::settings("metrics.factor"),
  cutoff = MachineShop::settings("cutoff"), na.rm = TRUE, ...)

\method{performance}{matrix}(x, y,
  metrics = MachineShop::settings("metrics.matrix"), na.rm = TRUE, ...)

\method{performance}{numeric}(x, y,
  metrics = MachineShop::settings("metrics.numeric"), na.rm = TRUE,
  ...)

\method{performance}{Surv}(x, y,
  metrics = MachineShop::settings("metrics.Surv"),
  cutoff = MachineShop::settings("cutoff"), na.rm = TRUE, ...)

\method{performance}{Confusion}(x, ...)

\method{performance}{ConfusionMatrix}(x,
  metrics = MachineShop::settings("metrics.ConfusionMatrix"), ...)

\method{performance}{Resamples}(x, ...)
}
\arguments{
\item{x}{\link[=response]{observed responses}; or \link{confusion} or
\link{resample} result containing observed and predicted responses.}

\item{...}{arguments passed from the \code{Resamples} method to the response
type-specific methods or from the method for \code{Confusion} to
\code{ConfusionMatrix}.}

\item{y}{\link[=predict]{predicted responses} if not contained in \code{x}.}

\item{metrics}{\link[=metrics]{metric} function, function name, or vector of
these with which to calculate performance.}

\item{cutoff}{numeric (0, 1) threshold above which binary factor
probabilities are classified as events and below which survival
probabilities are classified.}

\item{na.rm}{logical indicating whether to remove observed or predicted
responses that are \code{NA} when calculating metrics.}
}
\description{
Compute measures of model performance.
}
\examples{
res <- resample(Species ~ ., data = iris, model = GBMModel)
(perf <- performance(res))
summary(perf)
plot(perf)

## Survival response example
library(survival)
library(MASS)

fo <- Surv(time, status != 2) ~ sex + age + year + thickness + ulcer
gbm_fit <- fit(fo, data = Melanoma, model = GBMModel)

obs <- response(gbm_fit, newdata = Melanoma)
pred <- predict(gbm_fit, newdata = Melanoma, type = "prob")
performance(obs, pred)

}
\seealso{
\code{\link{plot}}, \code{\link{summary}}
}
