% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrainedInputs.R
\name{SelectedInput}
\alias{SelectedInput}
\alias{SelectedModelFrame}
\alias{SelectedModelRecipe}
\alias{SelectedInput.formula}
\alias{SelectedInput.matrix}
\alias{SelectedInput.ModelFrame}
\alias{SelectedInput.recipe}
\alias{SelectedInput.list}
\title{Selected Model Inputs}
\usage{
SelectedInput(...)

\method{SelectedInput}{formula}(
  ...,
  data,
  control = MachineShop::settings("control"),
  metrics = NULL,
  stat = MachineShop::settings("stat.train"),
  cutoff = MachineShop::settings("cutoff")
)

\method{SelectedInput}{matrix}(
  ...,
  y,
  control = MachineShop::settings("control"),
  metrics = NULL,
  stat = MachineShop::settings("stat.train"),
  cutoff = MachineShop::settings("cutoff")
)

\method{SelectedInput}{ModelFrame}(
  ...,
  control = MachineShop::settings("control"),
  metrics = NULL,
  stat = MachineShop::settings("stat.train"),
  cutoff = MachineShop::settings("cutoff")
)

\method{SelectedInput}{recipe}(
  ...,
  control = MachineShop::settings("control"),
  metrics = NULL,
  stat = MachineShop::settings("stat.train"),
  cutoff = MachineShop::settings("cutoff")
)

\method{SelectedInput}{list}(x, ...)
}
\arguments{
\item{...}{\link{inputs} specifying relationships between model predictor
and response variables.  Supplied inputs must all be of the same type and
may be named or unnamed.}

\item{data}{\link[=data.frame]{data frame} or an object that can be converted
to one.}

\item{control}{\link[=controls]{control} function, function name, or call
defining the resampling method to be employed.}

\item{metrics}{\link[=metrics]{metric} function, function name, or vector of
these with which to calculate performance.  If not specified, default
metrics defined in the \link{performance} functions are used.  Recipe
selection is based on the first calculated metric.}

\item{stat}{function or character string naming a function to compute a
summary statistic on resampled metric values for recipe selection.}

\item{cutoff}{argument passed to the \code{metrics} functions.}

\item{y}{response variable.}

\item{x}{list of inputs followed by arguments passed to their method
function.}
}
\value{
\code{SelectedModelFrame} or \code{SelectedModelRecipe} class object
that inherits from \code{SelectedInput} and \code{ModelFrame} or
\code{recipe}.
}
\description{
Formula, design matrix, model frame, or recipe selection from a candidate
set.
}
\examples{
## Selected model frame
sel_mf <- SelectedInput(
  sale_amount ~ sale_year + built + style + construction,
  sale_amount ~ sale_year + base_size + bedrooms + basement,
  data = ICHomes
)

fit(sel_mf, model = GLMModel)

## Selected recipe
library(recipes)
data(Boston, package = "MASS")

rec1 <- recipe(medv ~ crim + zn + indus + chas + nox + rm, data = Boston)
rec2 <- recipe(medv ~ chas + nox + rm + age + dis + rad + tax, data = Boston)
sel_rec <- SelectedInput(rec1, rec2)

fit(sel_rec, model = GLMModel)

}
\seealso{
\code{\link{fit}}, \code{\link{resample}}
}
