% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{diff}
\alias{diff}
\alias{diff.MLModel}
\alias{diff.Performance}
\alias{diff.Resamples}
\title{Model Performance Differences}
\usage{
\method{diff}{MLModel}(x, ...)

\method{diff}{Performance}(x, ...)

\method{diff}{Resamples}(x, ...)
}
\arguments{
\item{x}{model \link{performance} or \link{resample} result.}

\item{...}{arguments passed to other methods.}
}
\value{
\code{PerformanceDiff} class object that inherits from
\code{Performance}.
}
\description{
Pairwise model differences in resampled performance metrics.
}
\examples{
\donttest{
## Requires prior installation of suggested package gbm to run

## Survival response example
library(survival)

fo <- Surv(time, status) ~ .
control <- CVControl()

gbm_res1 <- resample(fo, data = veteran, GBMModel(n.trees = 25), control)
gbm_res2 <- resample(fo, data = veteran, GBMModel(n.trees = 50), control)
gbm_res3 <- resample(fo, data = veteran, GBMModel(n.trees = 100), control)

res <- c(GBM1 = gbm_res1, GBM2 = gbm_res2, GBM3 = gbm_res3)
res_diff <- diff(res)
summary(res_diff)
plot(res_diff)
}

}
\seealso{
\code{\link{t.test}}, \code{\link{plot}}, \code{\link{summary}}
}
