% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModeledInput.R
\name{ModeledInput}
\alias{ModeledInput}
\alias{ModeledFrame}
\alias{ModeledRecipe}
\alias{ModeledInput.formula}
\alias{ModeledInput.matrix}
\alias{ModeledInput.ModelFrame}
\alias{ModeledInput.recipe}
\alias{ModeledInput.MLModel}
\alias{ModeledInput.MLModelFunction}
\title{ModeledInput Classes}
\usage{
ModeledInput(...)

\method{ModeledInput}{formula}(formula, data, model, ...)

\method{ModeledInput}{matrix}(x, y, model, ...)

\method{ModeledInput}{ModelFrame}(object, model, ...)

\method{ModeledInput}{recipe}(object, model, ...)

\method{ModeledInput}{MLModel}(model, ...)

\method{ModeledInput}{MLModelFunction}(model, ...)
}
\arguments{
\item{...}{arguments passed from the generic function to its methods.  The
first arguments of \code{ModeledInput} methods are positional and, as such,
must be given first in calls to them.}

\item{formula, data}{\link[=formula]{formula} defining the model predictor and
response variables and a \link[=data.frame]{data frame} containing them.}

\item{model}{\link[=models]{model} function, function name, or object; or
another object that can be \link[=as.MLModel]{coerced} to a model.  Can
be given first followed by any of the variable specifications.}

\item{x, y}{\link{matrix} and object containing predictor and response
variables.}

\item{object}{\link[=inputs]{input} object defining and containing the model
predictor and response variables.}
}
\value{
\code{ModeledFrame} or \code{ModeledRecipe} class object that
inherits from \code{ModelFrame} or \code{recipe}.
}
\description{
Class for storing a model input and specification pair for \pkg{MachineShop}
model fitting.
}
\examples{
## Modeled model frame
mod_mf <- ModeledInput(sale_amount ~ ., data = ICHomes, model = GLMModel)
fit(mod_mf)

## Modeled recipe
library(recipes)

rec <- recipe(sale_amount ~ ., data = ICHomes)
mod_rec <- ModeledInput(rec, model = GLMModel)
fit(mod_rec)

}
\seealso{
\code{\link{as.MLModel}}, \code{\link{fit}}, \code{\link{resample}},
\code{\link{SelectedInput}}
}
