% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelinfo.R
\name{modelinfo}
\alias{modelinfo}
\title{Display Model Information}
\usage{
modelinfo(...)
}
\arguments{
\item{...}{\link[=models]{model} functions, function names, or objects;
\link[=response]{observed responses} for which to display information.  If
none are specified, information is returned on all available models by
default.}
}
\value{
List of named model elements each containing the following
components:
\describe{
  \item{label}{character descriptor for the model.}
  \item{packages}{character vector of source packages required to use the
    model.  These need only be installed with the
    \code{\link{install.packages}} function or by equivalent means; but need
    not be loaded with, for example, the \code{\link{library}} function.}
  \item{response_types}{character vector of response variable types supported
    by the model.}
 \item{weights}{logical value or vector of the same length as
   \code{response_types} indicating whether case weights are supported for
   the responses.}
  \item{arguments}{closure with the argument names and corresponding default
    values of the model function.}
  \item{grid}{logical indicating whether automatic generation of tuning
    parameter grids is implemented for the model.}
  \item{varimp}{logical indicating whether model-specific variable importance
    is defined.}
}
}
\description{
Display information about models supplied by the \pkg{MachineShop} package.
}
\examples{
## All models
modelinfo()

## Models by response types
names(modelinfo(factor(0)))
names(modelinfo(factor(0), numeric(0)))

## Model-specific information
modelinfo(GBMModel)

}
