% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbos.R
\name{elbo_monitoring_VEM}
\alias{elbo_monitoring_VEM}
\title{Evidence Lower Bound maximised in MagmaClust}
\usage{
elbo_monitoring_VEM(hp_k, hp_i, db, kern_i, kern_k, hyperpost, m_k, pen_diag)
}
\arguments{
\item{hp_k}{A tibble, data frame or named vector of hyper-parameters
for each clusters.}

\item{hp_i}{A tibble, data frame or named vector of hyper-parameters
for each individuals.}

\item{db}{A tibble containing values we want to compute elbo on.
Required columns: Input, Output. Additional covariate columns are allowed.}

\item{kern_i}{Kernel used to compute the covariance matrix of individuals GPs
at corresponding inputs.}

\item{kern_k}{Kernel used to compute the covariance matrix of the mean GPs
at corresponding inputs.}

\item{hyperpost}{A list of parameters for the variational distributions
of the K mean GPs.}

\item{m_k}{Prior value of the mean parameter of the mean GPs (mu_k).
Length = 1 or nrow(db).}

\item{pen_diag}{A jitter term that is added to the covariance matrix to avoid
numerical issues when inverting, in cases of nearly singular matrices.}
}
\value{
Value of the elbo that is maximised during the VEM algorithm used for
training in MagmaClust.
}
\description{
Evidence Lower Bound maximised in MagmaClust
}
\examples{
TRUE
}
