% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vem-magmaclust.R
\name{update_mixture}
\alias{update_mixture}
\title{Update the mixture probabilities for each individual and each cluster}
\usage{
update_mixture(db, mean_k, cov_k, hp, kern, prop_mixture, pen_diag)
}
\arguments{
\item{db}{A tibble or data frame. Columns required: \code{ID},
\code{Input}, \code{Output}. Additional columns for covariates can be
specified.}

\item{mean_k}{A list of the K hyper-posterior mean parameters.}

\item{cov_k}{A list of the K hyper-posterior covariance matrices.}

\item{hp}{A named vector, tibble or data frame of hyper-parameters
associated with \code{kern}, the individual process' kernel. The
columns/elements should be named according to the hyper-parameters
that are used in \code{kern}.}

\item{kern}{A kernel function, defining the covariance structure of
the individual GPs.}

\item{prop_mixture}{A tibble containing the hyper-parameters associated
with each individual, indicating in which cluster it belongs.}

\item{pen_diag}{A number. A jitter term, added on the diagonal to prevent
numerical issues when inverting nearly singular matrices.}
}
\value{
Compute the hyper-posterior multinomial distributions by updating
mixture probabilities.
}
\description{
Update the mixture probabilities for each individual and each cluster
}
\examples{
TRUE
}
