% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{inference}
\alias{inference}
\title{Given a test market, analyze the impact of an intervention}
\usage{
inference(matched_markets=NULL,
          bsts_modelargs=NULL,
          test_market=NULL,
          end_post_period=NULL,
          alpha=0.05,
          prior_level_sd=0.01,
          control_matches=5, 
          analyze_betas=FALSE, 
          nseasons=NULL)
}
\arguments{
\item{matched_markets}{A matched_market object created by the market_matching function}

\item{bsts_modelargs}{A list() that passes model parameters directly to bsts -- such as list(niter = 1000, nseasons = 52, prior.level.sd=0.1)
This parameter will overwrite the values specified in prior_level_sd and nseasons. ONLY use this if you're using intricate bsts settings
For most use-cases, using the prior_level_sd and nseasons parameters should be sufficient}

\item{test_market}{The name of the test market (character)}

\item{end_post_period}{The end date of the post period. Must be a character of format "YYYY-MM-DD" -- e.g., "2015-11-01"}

\item{alpha}{Desired tail-area probability for posterior intervals. For example, 0.05 yields 0.95 intervals}

\item{prior_level_sd}{Prior SD for the local level term (Gaussian random walk). Default is 0.01. The bigger this number is, the more wiggliness is allowed for the local level term.
Note that more wiggly local level terms also translate into larger posterior intervals
This parameter will be overwritten if you're using the bsts_modelargs parameter}

\item{control_matches}{Number of matching control markets to use in the analysis (default is 5)}

\item{analyze_betas}{Controls whether to test the model under a variety of different values for prior_level_sd.}

\item{nseasons}{Seasonality for the bsts model -- e.g., 52 for weekly seasonality}
}
\value{
Returns an object of type \code{inference}. The object has the
following elements:
\item{\code{AbsoluteEffect}}{The estimated absolute effect of the intervention}
\item{\code{AbsoluteEffectLower}}{The lower limit of the estimated absolute effect of the intervention.
This is based on the posterior interval of the counterfactual predictions.
The width of the interval is determined by the \code{alpha} parameter.}
\item{\code{AbsoluteEffectUpper}}{The upper limit of the estimated absolute effect of the intervention.
This is based on the posterior interval of the counterfactual predictions.
The width of the interval is determined by the \code{alpha} parameter.}
\item{\code{RelativeEffectLower}}{Same as the above, just for relative (percentage) effects}
\item{\code{RelativeEffectUpper}}{Same as the above, just for relative (percentage) effects}
\item{\code{TailProb}}{Posterior probability of a non-zero effect}
\item{\code{PrePeriodMAPE}}{Pre-intervention period MAPE}
\item{\code{DW}}{Durbin-Watson statistic. Should be close to 2.}
\item{\code{PlotActualVersusExpected}}{Plot of actual versus expected using \code{ggplot2}}
\item{\code{PlotCumulativeEffect}}{Plot of the cumulative effect using \code{ggplot2}}
\item{\code{PlotPointEffect}}{Plot of the pointwise effect using \code{ggplot2}}
\item{\code{PlotActuals}}{Plot of the actual values for the test and control markets using \code{ggplot2}}
\item{\code{PlotPriorLevelSdAnalysis}}{Plot of DW and MAPE for different values of the local level SE using \code{ggplot2}}
\item{\code{PlotLocalLevel}}{Plot of the local level term using \code{ggplot2}}
\item{\code{TestData}}{A \code{data.frame} with the test market data}
\item{\code{ControlData}}{A \code{data.frame} with the data for the control markets}
\item{\code{PlotResiduals}}{Plot of the residuals using \code{ggplot2}}
\item{\code{TestName}}{The name of the test market}
\item{\code{TestName}}{The name of the control market}
\item{\code{zooData}}{A \code{zoo} time series object with the test and control data}
\item{\code{Predictions}}{Actual versus predicted values}
\item{\code{CausalImpactObject}}{The CausalImpact object created}
\item{\code{Coefficients}}{The average posterior coefficients}
}
\description{
\code{inference} Analyzes the causal impact of an intervention using the CausalImpact package, given a test market and a matched_market object from the best_matches function.
The function returns an object of type "market_inference" which contains the estimated impact of the intervention (absolute and relative).
}
\examples{
\dontrun{
library(MarketMatching)
##-----------------------------------------------------------------------
## Analyze causal impact of a made-up weather intervention in Copenhagen
## Since this is weather data it is a not a very meaningful example. 
## This is merely to demonstrate the function.
##-----------------------------------------------------------------------
data(weather, package="MarketMatching")
mm <- best_matches(data=weather, 
                   id="Area",
                   markets_to_be_matched=c("CPH", "SFO"),
                   date_variable="Date",
                   matching_variable="Mean_TemperatureF",
                   parallel=FALSE,
                   warping_limit=1, # warping limit=1
                   dtw_emphasis=1, # rely only on dtw for pre-screening
                   matches=5, # request 5 matches
                   start_match_period="2014-01-01",
                   end_match_period="2014-10-01")
library(CausalImpact)
results <- inference(matched_markets=mm,
                     test_market="CPH",
                     analyze_betas=FALSE,
                     control_matches=5, # use all 5 matches for inference
                     end_post_period="2015-12-15",
                     prior_level_sd=0.002)
}
}
