% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilMWRsumfun.R
\name{utilMWRsumfun}
\alias{utilMWRsumfun}
\title{Verify summary function}
\usage{
utilMWRsumfun(accdat, param, sumfun = "auto")
}
\arguments{
\item{accdat}{\code{data.frame} for data quality objectives file for accuracy as returned by \code{\link{readMWRacc}}}

\item{param}{character string for the parameter to evaluate as provided in the \code{"Parameter"} column of \code{"accdat"}}

\item{sumfun}{character indicating one of \code{"auto"} (default), \code{"mean"}, \code{"geomean"}, \code{"median"}, \code{"min"}, or \code{"max"}, see details}
}
\value{
Character indicating the appropriate summary function based on the value passed to \code{sumfun}.
}
\description{
Verify summary function
}
\details{
This function verifies appropriate summary functions are passed from \code{sumfun}. The mean or geometric mean output is used for \code{sumfun = "auto"} based on information in the data quality objective file for accuracy, i.e., parameters with "log" in any of the columns are summarized with the geometric mean, otherwise arithmetic. Using \code{"mean"} or \code{"geomean"} for \code{sumfun} will apply the appropriate function regardless of information in the data quality objective file for accuracy.
}
\examples{
# accuracy path
accpth <- system.file('extdata/ExampleDQOAccuracy.xlsx', 
     package = 'MassWateR')

# accuracy data
accdat <- readMWRacc(accpth)

# geomean auto
utilMWRsumfun(accdat, param = 'E.coli')

# mean force
utilMWRsumfun(accdat, param = 'E.coli', sumfun = 'mean')

# mean auto
utilMWRsumfun(accdat, param = 'DO')

# geomean force
utilMWRsumfun(accdat, param = 'DO', sumfun = 'geomean')
}
