% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.wimids.R
\name{print.wimids}
\alias{print.wimids}
\title{Prints a \code{wimids} Class Object}
\usage{
\method{print}{wimids}(x, n = 1, digits = getOption("digits"), ...)
}
\arguments{
\item{x}{This argument specifies an object of the \code{wimids} class.}

\item{n}{This argument specifies number of the weighted imputed dataset intended to print its matching profile. The input must be a positive integer. The default is \code{1}.}

\item{digits}{This argument specifies minimal number of significant digits.}

\item{...}{Additional arguments to be passed to the \code{print.wimids()} function.}
}
\description{
The \code{print.wimids()} function prints an object of the \code{wimids} class.
}
\details{
The matching profile of the \code{wimids} class objects is printed.
}
\examples{
\donttest{
#Loading the 'handoa' dataset
data(handoa)

#Imputing the missing data points in the 'handoa' dataset
datasets <- mice(handoa, m = 5, maxit = 1,
                 method = c("", "", "", "mean", "polyreg", "logreg", "", ""))

#Weighting the imputed datasets, 'datasets'
weighteddatasets <- weightitmice(HANDOA ~ SEX + AGE, datasets)

#Printing data of the first imputed dataset
print1 <- print(weighteddatasets, n = 1)
}
}
\references{
Daniel Ho, Kosuke Imai, Gary King, and Elizabeth Stuart (2007). Matching as Nonparametric Preprocessing for Reducing Model Dependence in Parametric Causal Inference. \emph{Political Analysis}, 15(3): 199-236. \url{http://gking.harvard.edu/files/abs/matchp-abs.shtml}
}
\seealso{
\code{\link[=wimids]{wimids}}
}
\author{
Farhad Pishgar
}
