% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance_ratio.R
\name{compute_var_ratio}
\alias{compute_var_ratio}
\title{Compute the ratio of the variances of propensity score in the two groups}
\usage{
compute_var_ratio(mi_obj = NULL)
}
\arguments{
\item{mi_obj}{A matchit object derived from MatchIt pacakge}
}
\value{
Return a vector of variances and variance ratios
}
\description{
This function accepts a MatchIt object (i.e., the result of matchit function)
, and calculates variance of propensity score in the two groups before and
after matching. The variance ratio is an indicator proposed by Rubin (2001)
to assess the similarity of distributions between groups.
}
\examples{
m_out <- MatchIt::matchit(treat ~ re74 + re75 + age + educ + hispan +
black, data = MatchIt::lalonde, method = "nearest")
compute_var_ratio(m_out)
}
\references{
Rubin, D. B. (2001). Using propensity scores to help design
observational studies: Application to the tobacco litigation. \emph{Health
Services and Outcomes Research Methodology, 2}(3/4), 169-188.
https://doi.org/10.1023/A:1020363010465
}
\seealso{
compute_res_var_ratio()
}
\keyword{ratio}
\keyword{variance}
