% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with.R
\name{with}
\alias{with}
\alias{with.mimids}
\alias{with.wimids}
\title{Evaluates an Expression in Matched or Weighted Imputed Datasets}
\usage{
\method{with}{mimids}(data, expr, ...)

\method{with}{wimids}(data, expr, ...)
}
\arguments{
\item{data}{This argument specifies an object of the \code{mimids} or \code{wimids} class, typically produced by a previous call to the \code{matchthem()} or \code{weightthem()}.}

\item{expr}{This argument specifies an expression of the usual syntax of R formula (it also accepts expressions from \pkg{survey} package, like \code{svyglm()}, please note that you shouldn't include the \code{weights = weights} argument, see the package vignette for details).}

\item{...}{Additional arguments to be passed to \code{expr}.}
}
\value{
This function returns an object of the \code{mimira} class.
}
\description{
\code{with()} function performs a statistical computation on the \code{n} imputed datasets of the \code{mimids} or \code{wimids} objects. The typical sequence of steps to do a matching or weighting procedure on the imputed datasets are:
\enumerate{
 \item Impute the missing values by the \code{mice()} function (from the \pkg{mice} package) or the \code{amelia()} function (from the \pkg{Amelia} package), resulting in a multiple imputed dataset (an object of the \code{mids} or \code{amelia} class);
 \item Match or weight imputed datasets using a matching or weighting model by the \code{matchthem()} or \code{weightthem()} function, resulting in an object of the \code{mimids} or \code{wimids} class;
 \item Check the extent of balance of covariates across the datasets;
 \item Fit the statistical model of interest on each dataset by the \code{with()} function, resulting in an object of the \code{mimira} class; and
 \item Pool the estimates from each model into a single set of estimates and standard errors, resulting in an object of the \code{mimipo} class.
}
}
\details{
\code{with()} performs a computation on the imputed datasets.
}
\examples{
\donttest{#Loading the dataset
data(osteoarthritis)

#Multiply imputing the missing values
imputed.datasets <- mice(osteoarthritis, m = 5, maxit = 10,
                         method = c("", "", "mean", "polyreg",
                                    "logreg", "logreg", "logreg"))

#Estimating weights of observations in the multiply imputed datasets
weighted.datasets <- weightthem(OSP ~ AGE + SEX + BMI + RAC + SMK, imputed.datasets,
                                approach = 'within', method = 'ps')

#Analyzing the weighted datasets
models <- with(data = weighted.datasets,
               exp = svyglm(KOA ~ OSP, family = binomial))}
}
\references{
Stef van Buuren and Karin Groothuis-Oudshoorn (2011). \code{mice}: Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of Statistical Software}, 45(3): 1-67. \url{https://www.jstatsoft.org/v45/i03/}
}
\seealso{
\code{\link[=matchthem]{matchthem}}

\code{\link[=weightthem]{weightthem}}
}
\author{
Farhad Pishgar
}
