% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.R
\name{is.mimira}
\alias{is.mimira}
\title{Checks for the \code{mimira} Class}
\usage{
is.mimira(object)
}
\arguments{
\item{object}{This argument specifies the object that should be checked to see if it is of the \code{mimira} class or not.}
}
\value{
This function returns a logical value indicating whether \code{object} is of the \code{mimira} class.
}
\description{
\code{is.mimira()} function checks whether class of objects is \code{mimira} or not.
}
\details{
The class of objects is checked to be of the \code{mimira}.
}
\examples{
\donttest{#Loading libraries
library(MatchThem)
library(survey)

#Loading the dataset
data(osteoarthritis)

#Multiply imputing the missing values
imputed.datasets <- mice::mice(osteoarthritis, m = 5)

#Estimating weights of observations in the multiply imputed datasets
weighted.datasets <- weightthem(OSP ~ AGE + SEX + BMI + RAC + SMK,
                                imputed.datasets,
                                approach = 'within',
                                method = 'ps',
                                estimand = "ATT")

#Analyzing the weighted datasets
models <- with(data = weighted.datasets,
               exp = svyglm(KOA ~ OSP, family = binomial))

#Checking the 'models' object
is.mimira(models)
is(models)}
}
\seealso{
\code{\link[=with]{with}}

\code{\link[=mimira]{mimira}}
}
\author{
Farhad Pishgar
}
