% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{MSE_sim}
\alias{MSE_sim}
\alias{MSE_parameters}
\title{The function to get the mean square error values for statistics of simulations}
\usage{
MSE_sim(stat.obs, stat.sim)

MSE_parameters(par.truth, par.top = NULL, par.best)
}
\arguments{
\item{stat.obs}{Summary statistics of the observation point}

\item{stat.sim}{Summary statistics of the simulations (model output)}

\item{par.truth}{The truth parameter}

\item{par.top}{Parameters from the top of similarities of \code{get.MaxWiK()} algorithm}

\item{par.best}{The best parameter from \code{get.MaxWiK()} algorithm}
}
\value{
The function \code{MSE_sim()} returns numeric vector of
the mean square error values for statistics of simulations

The function \code{MSE_parameters()} returns list of two numbers: \cr
\itemize{
\item mean of MSE values for all the points from par.top; \cr
\item MSE value for the point of par.best
}
}
\description{
The function \code{MSE_sim()} allows to get
the mean square error values for statistics of simulations

The function \code{MSE_parameters()} allows to get MSE for parameters if the truth parameter is known
}
\section{Functions}{
\itemize{
\item \code{MSE_parameters()}: The function calculates mean square error (MSE) value
for parameters as differences between them and already the known truth parameter

}}
\examples{
NULL
NULL 
}
\keyword{internal}
