% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods.R
\name{infer}
\alias{infer}
\title{Inference method for class "Maximin"}
\usage{
infer(
  object,
  delta = 0,
  gen.size = 500,
  threshold = 0,
  alpha = 0.05,
  alpha.thres = 0.01
)
}
\arguments{
\item{object}{Object of class inheriting from "Maximin"}

\item{delta}{The ridge penalty (Default = 0)}

\item{gen.size}{The generating sample size (Default = 500)}

\item{threshold}{Should generated samples be filtered or not?
if 0, use normal threshold to filter;
if 1, use chi-square threshold to filter;
if 2, do not filter (Default = 0)}

\item{alpha}{confidence value to construct confidence interval (Default = 0.05)}

\item{alpha.thres}{confidence value to select generated samples (Default = 0.01)}
}
\value{
\item{weight}{The weight vector for groups, of length \eqn{L}}
\item{point}{The point estimator of the linear combination}
\item{mm.effect}{The aggregated maximin effect (coefficients), of length \eqn{p} or \eqn{p+1}}
\item{CI}{Confidence interval for the linear combination}
}
\description{
Point estimator and Confidence interval based on Maximin object
}
\examples{
## The problem is low-dimensional and we do sampling only 5 times instead of 500 for testings
## heterogenous data and covariates shift
X1 = sample_data$X1
X2 = sample_data$X2
Y1 = sample_data$Y1
Y2 = sample_data$Y2
X.target = sample_data$X.target

## loading
loading = rep(0, 5) # dimension p=5
loading[5] = 1

## call
mm <- Maximin(list(X1, X2), list(Y1, Y2), loading, X.target, covariate.shift = TRUE)
mmInfer <- infer(mm, gen.size=5)
}
