% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_addSingleLocation.R
\name{table_addSingleLocation}
\alias{table_addSingleLocation}
\title{Add a single new known location record to a table}
\usage{
table_addSingleLocation(locationTbl = NULL, longitude = NULL,
  latitude = NULL, radius = NULL, stateDataset = "NaturalEarthAdm1",
  verbose = TRUE)
}
\arguments{
\item{locationTbl}{Tibble of known locations, Default: NULL}

\item{longitude}{Single longitude in decimal degrees E, Default: NULL}

\item{latitude}{Single latitude in decimal degrees N, Default: NULL}

\item{radius}{Radius in meters, Default: NULL}

\item{stateDataset}{Name of spatial dataset to use for determining state
codes, Default: 'NaturalEarthAdm1'}

\item{verbose}{Logical controlling the generation of progress messages.}
}
\value{
Updated tibble of known locations.
}
\description{
Incoming \code{longitude} and \code{latitude} values are compared 
against the incoming \code{locationTbl} to see if the are already within
\code{radius} meters of an existing entry.  A new record is created for
if the location is not already found in \code{locationTbl}.
}
\examples{
\donttest{
# Set up standard directories and spatial data
spatialDataDir <- tempdir() # typically "~/Data/Spatial"
MazamaSpatialUtils::setSpatialDataDir(spatialDataDir)

locationTbl <- get(data("wa_monitors_500"))

# Coulee City, WA
lon <- -119.290904
lat <- 47.611942

locationTbl <- 
  locationTbl \%>\%
  table_addSingleLocation(lon, lat, radius = 500)
}
}
\seealso{
\link{table_addLocation}

\link{table_removeRecord}

\link{table_updateSingleRecord}
}
