% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_removeColumn.R
\name{table_removeColumn}
\alias{table_removeColumn}
\title{Remove a column of metadata in a table}
\usage{
table_removeColumn(locationTbl = NULL, columnName = NULL, verbose = TRUE)
}
\arguments{
\item{locationTbl}{Tibble of known locations.}

\item{columnName}{Name of the colun to be removed.}

\item{verbose}{Logical controlling the generation of progress messages.}
}
\value{
Updated tibble of known locations.
}
\description{
Remove the column matching \code{columnName}. This function
can be used in pipelines.
}
\examples{
library(MazamaLocationUtils)

# Starting table
locationTbl <- get(data("wa_monitors_500")) 
names(locationTbl)

# Add a new column
locationTbl <-
  locationTbl \%>\%
  table_addColumn("siteName")
  
names(locationTbl)

# Now remove it
locationTbl <-
  locationTbl \%>\%
  table_removeColumn("siteName")

names(locationTbl)

try({
  # Cannot remove "core" metadata
  locationTbl <-
    locationTbl \%>\%
    table_removeColumn("zip")
}, silent = FALSE)

}
\seealso{
\link{table_addColumn}

\link{table_removeColumn}
}
