% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_updateColumn.R
\name{table_updateColumn}
\alias{table_updateColumn}
\title{Update a column of metadata in a table}
\usage{
table_updateColumn(
  locationTbl = NULL,
  columnName = NULL,
  locationID = NULL,
  locationData = NULL,
  verbose = TRUE
)
}
\arguments{
\item{locationTbl}{Tibble of known locations.}

\item{columnName}{Name to use for the new column.}

\item{locationID}{Vector of \code{locationID} strings.}

\item{locationData}{Vector of data to used at matching records.}

\item{verbose}{Logical controlling the generation of progress messages.}
}
\value{
Updated tibble of known locations.
}
\description{
For matching \code{locationID}, records the associated
\code{locationData} is used to replace any existing value in \code{columnName}.
\code{NA} values in \code{locationID} will be ignored.
}
\examples{
library(MazamaLocationUtils)

locationTbl <- get(data("wa_monitors_500"))
wa <- get(data("wa_airfire_meta"))

# We will merge some metadata from wa into locationTbl

# Record indices for wa
wa_indices <- seq(5,65,5)
wa_sub <- wa[wa_indices,]

locationID <- 
  table_getLocationID(
    locationTbl, 
    wa_sub$longitude, 
    wa_sub$latitude, 
    distanceThreshold = 500
  )
  
locationData <- wa_sub$siteName

locationTbl <- 
  table_updateColumn(locationTbl, "siteName", locationID, locationData)

# Look at the data we attempted to merge
wa$siteName[wa_indices]

# And two columns from the updated locationTbl
locationTbl_indices <- table_getRecordIndex(locationTbl, locationID)
locationTbl[locationTbl_indices, c("city", "siteName")]

}
\seealso{
\link{table_addColumn}

\link{table_removeColumn}
}
