% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/convertWBDHUC.R
\name{convertWBDHUC}
\alias{convertWBDHUC}
\title{Convert Watershed Boundary Dataset Hydrologic Unit Shapefile}
\usage{
convertWBDHUC(digit = 2, simplified = TRUE, nameOnly = FALSE)
}
\arguments{
\item{digit}{numeric value specifying which digit level huc to be converted -- defaults to 2}

\item{simplified}{logical specifying whether to use the simplified HUC shapefile}

\item{nameOnly}{logical specifying whether to only return the name without creating the file}
}
\value{
Name of the dataset being created.
}
\description{
Returns a SpatialPolygons Data Frame for hydrologic unit divisions
}
\details{
A hydrologic unit shapefile is converted to a SpatialPolygonsDataFrame. The
resulting file will be created in the package \code{SpatialDataDir} which can be set
with \code{setSpatialDataDir()}.

Original data is downloaded from ftp://ftp.ftw.nrcs.usda.gov/wbd/ as a .gdb file.
User must download QGIS to convert .gdb files to shapefiles. The shapefile directory must have
the correct naming convention ('WBD_HUC_2' for 2-digit huc, and so on) and it must be in the
internal data directory set by \code{setSpatialDataDir()}.
}
\references{
ftp://ftp.ftw.nrcs.usda.gov/wbd/
}
\seealso{
setSpatialDataDir
}
\keyword{datagen}

