% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertUSCensusCBSA.R
\name{convertUSCensusCBSA}
\alias{convertUSCensusCBSA}
\title{Convert US Core Based Statistical Areas shapefile}
\usage{
convertUSCensusCBSA()
}
\value{
Name of the datasetName being created.
}
\description{
Returns a simple features data frame for US CBSAs

The full resolution file will be named "USCensusCBSA.rda". In addition,
"_05", _02" and "_01" versions of the file will be created that that are
simplified to 5\%, 2\% and 1\%. Simplified versions will greatly improve the
speed of both searching and plotting.
}
\details{
A US Core Based Statistical Areas (CBSA) shapefile is downloaded and converted to a
simple features data frame with additional columns of data. The resulting file
will be created in the spatial data directory which is set with
\code{setSpatialDataDir()}.
}
\note{
From the source documentation:

Metropolitan and Micropolitan Statistical Areas are together termed Core Based
Statistical Areas (CBSAs) and are defined by the Office of Management and Budget
(OMB) and consist of the county or counties or equivalent entities associated
with at least one urban core (urbanized area or urban cluster) of at least 10,000
population, plus adjacent counties having a high degree of social and economic
integration with the core as measured through commuting ties with the counties
containing the core. Categories of CBSAs are: Metropolitan Statistical Areas,
based on urbanized areas of 50,000 or more population; and Micropolitan Statistical
Areas, based on urban clusters of at least 10,000 population but less than 50,000
population.

The CBSA boundaries are those defined by OMB based on the 2010 Census,
published in 2013, and updated in 2020.
}
\references{
\url{https://www2.census.gov/geo/tiger/TIGER2021/CBSA/}
}
\seealso{
setSpatialDataDir

getUSCounty
}
