% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mts_pull.R
\name{mts_pull}
\alias{mts_pull}
\title{Extract a column of metadata or data}
\usage{
mts_pull(mts = NULL, var = NULL)
}
\arguments{
\item{mts}{\emph{mts} object.}

\item{var}{A variable name found in the \code{meta} or \code{data}
dataframe of the incoming \emph{mts} time series object.}
}
\value{
An array of values.
}
\description{
This function acts similarly to \code{dplyr::pull()} working on
\code{mts$meta} or \code{mts$data}. Data are returned as a simple array.
Data are pulled from whichever dataframe contains \code{var}.
}
\examples{
library(MazamaTimeSeries)

# Metadata
example_mts \%>\%
  mts_pull("communityRegion") \%>\%
  table() \%>\%
  sort(decreasing = TRUE)

# Data for a specific ID
example_mts \%>\%
  mts_pull("da4cadd2d6ea5302_4686")

}
