% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satVP.R
\name{satVP}
\alias{satVP}
\title{Saturation Vapor Pressure}
\usage{
satVP(Tmax = NULL, Tmin = NULL, Tmean = NULL, interval = "day",
  print.warning = T)
}
\arguments{
\item{Tmax}{maximum temperature [degreeC] for daily, weekly, monthly periods}

\item{Tmin}{minimum temperature [degreeC] for daily, weekly, monthly periods}

\item{Tmean}{mean air temperature [degreeC] for hourly or shorter periods}

\item{interval}{hour, day, week or month}

\item{print.warning}{TRUE or FALSE}
}
\value{
Saturation Vapor Pressure [kPa]
}
\description{
Saturation vapor pressure [kPa].
}
\details{
\describe{\item{interval:}{hour (eq. 11 of reference)}
\item{interval:}{day, week or month (eq. 12 of reference or eq. 11 if only Tmean is provided)}
}
}
\examples{
satVP(Tmax = 24.5, Tmin = 15, interval = 'day')
satVP(Tmax = 24.5, Tmin = 15, interval = 'week')
satVP(Tmax = 24.5, Tmin = 15, interval = 'month')

satVP(Tmax = 24.5, Tmin = 15, interval = 'hour')
satVP(Tmean = 19.75, interval = 'hour')
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998). Crop evapotranspiration-Guidelines for computing crop water requirements-FAO Irrigation and drainage paper 56. FAO, Rome, 300(9).
}
\seealso{
\code{\link{e0}}, \code{\link{VP}}
}
