% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2riterate.R
\name{setfam}
\alias{setfam}
\title{replace the pedigree data frame}
\usage{
setfam(fam, envir = ENV)
}
\arguments{
\item{fam}{data frame of family information filtered from \emph{fam}
data frame (generated by \code{mkfam}).}

\item{envir}{an 'environment' that contains all the data frames created from the SQLite database.}
}
\value{
None
}
\description{
You should first modify the \emph{fam} data frame to filter the members you need to remove.
 (For example, you might  want to delete members that have an unknown case/control status.)
 This function takes a new data frame of pedigree information and replaces the \emph{fam}
 data frame in the 'environment' with it.  Additionally,
 changing \emph{fam} data frame will filter the genotypes data frame to only contain persons
 matching those in the \emph{fam} data frame.  \code{setfam} also filters for the phenotype data
 records.
}
\examples{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
ENV = read.Mega2DB(db)

fam = mkfam()
# remove founders
fam = fam[ !( (fam[ , 5] == fam[ , 6]) & (fam[ , 5] == 0)), ]
setfam(fam)

ENV$fam
}
