% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mr_cML-methods.R
\name{cML_estimate}
\alias{cML_estimate}
\title{Estimate with Regular Likelihood}
\usage{
cML_estimate(
  b_exp,
  b_out,
  se_exp,
  se_out,
  K,
  initial_theta = 0,
  initial_mu = rep(0, length(b_exp)),
  maxit = 100
)
}
\arguments{
\item{b_exp}{Vector of estimated effects for exposure.}

\item{b_out}{Vector or estimated effects for outcome.}

\item{se_exp}{Vector of standard errors for exposure.}

\item{se_out}{Vector of standard errors for outcome.}

\item{K}{Constraint parameter, number of invalid IVs.}

\item{initial_theta}{Starting point for theta.}

\item{initial_mu}{Starting point for mu.}

\item{maxit}{Maximum number of iteration.}
}
\value{
A list contains: theta is the estimate causal effect,
b_vec is the estimated vector of b,
r_vec is the estimated vector of r.
}
\description{
Internal function of mr_cML.
Estimate theta, b vector, r vector with constrained maximum likelihood.
}
\examples{
cML_estimate(b_exp = ldlc,b_out = chdlodds,se_exp = ldlcse,
se_out = chdloddsse, K = 5)
}
