% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{MRMVInput-class}
\alias{MRMVInput-class}
\title{MRMVInput Class}
\description{
An object containing the summary statistics required to calculate multivariable Mendelian randomization estimates.
}
\details{
The beta-coefficients are assumed to be estimated for uncorrelated (independent) genetic variants, although a correlation matrix can be specified if the variants are correlated in their distributions. We also assume that the beta-coefficients for associations with the exposure and with the outcome are uncorrelated (corresponding to a two-sample Mendelian randomization analysis), although correlation between associations with the exposure and with the outcome generally have little impact on causal estimates or standard errors.
}
\section{Slots}{

\describe{
\item{\code{betaX}}{A matrix of beta-coefficient values for genetic associations with the risk factor variables. These should be arranged so that column 1 are the beta-coefficients for risk factor 1, and row 1 are the beta-coefficients for genetic variant 1.}

\item{\code{betaY}}{A numeric vector of beta-coefficient values for genetic associations with the second variable (often referred to as the outcome). For a disease outcome, the beta coefficients are log odds estimates from logistic regression analyses.}

\item{\code{betaXse}}{The matrix of standard errors associated with the beta-coefficients in \code{betaX}.}

\item{\code{betaYse}}{The vector of standard errors associated with the beta-coefficients in \code{betaY}.}

\item{\code{correlation}}{The matrix of correlations between genetic variants. If this variable is not provided, then we assume that genetic variants are uncorrelated.}

\item{\code{exposure}}{The names of the exposure variables.}

\item{\code{outcome}}{The name of the outcome variable.}

\item{\code{snps}}{The names of the genetic variants (SNPs) included in the analysis. The slots \code{exposure}, \code{outcome}, and \code{snps} are not required, but may be useful for keeping track of various \code{MRInput} objects. They are also used by the \code{mr_plot} function.}

\item{\code{effect_allele}}{The name of the effect allele for each SNP. The beta-coefficients are the associations with the exposure and outcome per additional copy of the effect allele.}

\item{\code{other_allele}}{The name of the non-effect allele.}

\item{\code{eaf}}{The expected allele frequencies (numeric). The slots \code{effect_allele}, \code{other_allele}, and \code{eaf} are neither required, nor currently used in the MendelianRandomization package. They are included for future compatibility with the MR-Base suite of functions.}
}}

