% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_data_methods.R
\name{updateMetaData}
\alias{updateMetaData}
\alias{updateMetaData,MetAlyzer-method}
\title{Update meta data}
\usage{
updateMetaData(object, name, new_colum)

\S4method{updateMetaData}{MetAlyzer}(object, name, new_colum)
}
\arguments{
\item{object}{MetAlyzer object}

\item{name}{The new column name}

\item{new_colum}{A vector for the new column (length has to be same as the
number of filtered samples)}
}
\value{
An updated MetAlyzer object
}
\description{
This method adds another column to filtered meta_data.
}
\section{Methods (by class)}{
\itemize{
\item \code{MetAlyzer}: Update meta data
}}

\examples{
fpath <- system.file("extdata", "example_data.xlsx", package = "MetAlyzer")
obj <- MetAlyzerDataset(file_path = fpath)

obj <- updateMetaData(obj, name = Date, new_colum = Sys.Date())
obj <- updateMetaData(obj, name = Analyzed, new_colum = TRUE)
}
