% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_anova.R
\name{calculate_anova}
\alias{calculate_anova}
\title{One-way ANOVA}
\usage{
calculate_anova(
  metalyzer_se,
  categorical,
  groups = NULL,
  impute_perc_of_min = 0.2,
  impute_NA = TRUE
)
}
\arguments{
\item{metalyzer_se}{A Metalyzer object}

\item{categorical}{A column defining the categorical variable}

\item{groups}{A vector of column names of aggregated_data to calculate the
ANOVA group wise. If the column does not exists in aggregated_data it is
automatically added from meta data. The default value is set to NULL, which
uses the existing grouping of aggregated_data.}

\item{impute_perc_of_min}{A numeric value below 1}

\item{impute_NA}{Logical value whether to impute NA values}
}
\value{
A data frame containing the log2 fold change for each metabolite
}
\description{
This method performs a one-way ANOVA on the grouped aggregated_data (the
categorical variable is removed from grouping first). The vector of the
categorical variable needs to have at least two levels after removing NAs
from the dependent variable vector. Otherwise a vector of NA is returned.
A Tukey post-hoc test is then used to determine group names, starting with
"A" followed by further letters. These group names are added to
aggregated_data in the column ANOVA_Group. Thereby, metabolites can be
identified which are significantly higher in one or more of the categorical
variable compared to all other for each metabolite.
}
\examples{
metalyzer_se <- MetAlyzer_dataset(file_path = example_extraction_data())
metalyzer_se <- renameMetaData(
  metalyzer_se,
  Extraction_Method = "Sample Description"
)
# reduced to only 'Acylcarnitines' (first metabolic class) for simplicity
drop_vec = unique(metalyzer_se@elementMetadata$metabolic_classes)[2:24]
metalyzer_se <- filterMetabolites(
  metalyzer_se,
  drop_metabolites = drop_vec
)
metalyzer_se <- filterMetaData(
  metalyzer_se,
  Tissue == "Drosophila"
)
metalyzer_se <- calculate_anova(
  metalyzer_se,
  categorical = "Extraction_Method",
  groups = c("Metabolite"),
  impute_perc_of_min = 0.2,
  impute_NA = TRUE
)
}
