% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-db_search.R
\name{searchCMMR}
\alias{searchCMMR}
\title{Search CMMR}
\usage{
searchCMMR(
  cmm_url = "http://ceumass.eps.uspceu.es/mediator/api/v3/batch",
  metabolites_type = "all-except-peptides",
  databases = "[\\"all-except-mine\\"]",
  masses_mode = "mz",
  ion_mode = "positive",
  adducts = switch(ion_mode, positive =
    "[\\"M+H\\", \\"M+2H\\", \\"M+Na\\", \\"M+K\\", \\"M+NH4\\", \\"M+H-H2O\\"]",
    negative = "[\\"M-H\\", \\"M+Cl\\", \\"M+FA-H\\", \\"M-H-H2O\\"]"),
  tolerance = 10,
  tolerance_mode = "ppm",
  unique_mz
)
}
\arguments{
\item{cmm_url}{API base url, Default: 'http://ceumass.eps.uspceu.es/mediator/api/v3/batch'}

\item{metabolites_type}{Which type of metabolites to consider?, Default: 'all-except-peptides'}

\item{databases}{Which databases to consider?, Default: '["all-except-mine"]'}

\item{masses_mode}{Format of input compound, Default: 'mz'}

\item{ion_mode}{Which ion mode was the compound found in?, Default: 'positive'}

\item{adducts}{Adducts to be considered, Default: switch(ion_mode, positive = "[\"M+H\", \"M+2H\", \"M+Na\", \"M+K\", \"M+NH4\", \"M+H-H2O\"]",
negative = "[\"M-H\", \"M+Cl\", \"M+FA-H\", \"M-H-H2O\"]")}

\item{tolerance}{Error margin, units of 'tolerance_mode', Default: 10}

\item{tolerance_mode}{Mode of error margin, Default: 'ppm'}

\item{unique_mz}{M/z(s) to use in query}
}
\value{
Data table with match results
}
\description{
Queries Ceu Mass Mediator through their API
}
\examples{
searchCMMR(unique_mz = "170.09240307", ion_mode = "positive")
}
\seealso{
\code{\link[cmmr]{create_batch_body}}
 \code{\link[httr]{POST}},\code{\link[httr]{content_type}},\code{\link[httr]{content}}
 \code{\link[RJSONIO]{fromJSON}}
 \code{\link[progress]{progress_bar}}
 \code{\link[data.table]{rbindlist}}
}
