\name{forestPlot}
\alias{forestPlot}
\title{
Compare effect sizes of a gene across all datasets in meta-analysis
}
\description{
A forest plot can be used to compare the expression values of a gene across different datasets. The size of the blue boxes is proportional to the number of samples in the study and light blue lines indicate the standard error of the effect sizes for each study (95\% confidence interval). The summary effect size for all studies is indicated as yellow diamond below and the width of the diamond indicates the summary standard error.
}
\usage{
forestPlot(metaObject, geneName)
}
\arguments{
  \item{metaObject}{a filtered metaObject, i.e. it needs to include a \code{filterObject} generated by the function \code{filterGenes()} }
  \item{geneName}{name of the gene for which the forest plot should be generated}
}
\value{
  \item{forest plot}{Plot to compare effect sizes of a gene across datasets}
}
\author{
	Winston A. Haynes
}

\seealso{
 \code{\link{filterGenes}},  \code{\link{runMetaAnalysis}},  \code{\link{violinPlot}}
}
\examples{
# compare effect sizes of the Gene1 for all discovery datasets in tinyMetaObject 
forestPlot(tinyMetaObject, geneName="Gene1")
}

\keyword{ hplot }   
\keyword{ graphs }
