% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{c_net_annotate}
\alias{c_net_annotate}
\title{Annotate a metanet}
\usage{
c_net_annotate(go, anno_tab, mode = "v", verbose = TRUE)
}
\arguments{
\item{go}{metanet object}

\item{anno_tab}{a dataframe using to annotate (mode v, e), or a list (mode n)}

\item{mode}{"v" for vertex, "e" for edge, "n" for network}

\item{verbose}{logical}
}
\value{
a annotated metanet object
}
\description{
Annotate a metanet
}
\examples{
data("c_net")
anno <- data.frame("name" = "s__Pelomonas_puraquae", new_atr = "new")
co_net_new <- c_net_annotate(co_net, anno, mode = "v")
get_v(co_net_new, c("name", "new_atr"))

anno <- data.frame("from" = "s__Pelomonas_puraquae", "to" = "s__un_g__Rhizobium", new_atr = "new")
co_net_new <- c_net_annotate(co_net, anno, mode = "e")
get_e(co_net_new, c("from", "to", "new_atr"))

co_net_new <- c_net_annotate(co_net, list(new_atr = "new"), mode = "n")
get_n(co_net_new)
}
\seealso{
Other manipulate: 
\code{\link{anno_edge}()},
\code{\link{anno_vertex}()},
\code{\link{c_net_filter}()},
\code{\link{c_net_save}()},
\code{\link{c_net_union}()},
\code{\link{get_e}()},
\code{\link{get_n}()},
\code{\link{get_v}()},
\code{\link{is_metanet}()}
}
\concept{manipulate}
