% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{g_layout_polygon}
\alias{g_layout_polygon}
\alias{g_layout_polyarc}
\alias{g_layout_polycircle}
\title{Layout with group as a polygon}
\usage{
g_layout_polygon(
  go,
  group = "v_group",
  group_order = NULL,
  group2 = NULL,
  group2_order = NULL,
  line_curved = 0.5
)

g_layout_polyarc(
  go,
  group = "v_group",
  group_order = NULL,
  group2 = NULL,
  group2_order = NULL,
  space = pi/4,
  scale_node_num = TRUE
)

g_layout_polycircle(
  go,
  group = "v_group",
  group_order = NULL,
  group2 = NULL,
  group2_order = NULL
)
}
\arguments{
\item{go}{igraph}

\item{group}{group name (default:v_group)}

\item{group_order}{group_order}

\item{group2}{group2 name, will order nodes in each group according to group2_order}

\item{group2_order}{group2_order}

\item{line_curved}{line_curved 0~1}

\item{space}{the space between each arc, default: pi/4}

\item{scale_node_num}{scale with the node number in each group}
}
\value{
coors
}
\description{
Layout with group as a polygon

Layout with group as a polyarc

Layout with group as a polyarc
}
\examples{
g_layout_polygon(multi1) -> oridata
c_net_plot(multi1, oridata)
g_layout_polyarc(multi1, group2 = "v_class", group2_order = c(LETTERS[4:1])) -> oridata
c_net_plot(multi1, oridata)
g_layout_polycircle(co_net2, group2 = "v_class") -> oridata
c_net_plot(co_net2, oridata)
}
\seealso{
Other g_layout: 
\code{\link{g_layout}()}
}
\concept{g_layout}
