% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5.topological.R
\name{rand_net_par}
\alias{rand_net_par}
\alias{compare_rand}
\title{Net_pars of many random network}
\usage{
rand_net_par(go, reps = 99, threads = 1, verbose = TRUE)

compare_rand(
  pars,
  randp,
  index = c("Average_path_length", "Clustering_coefficient")
)
}
\arguments{
\item{go}{igraph}

\item{reps}{simulation time}

\item{threads}{threads}

\item{verbose}{verbose}

\item{pars}{your net pars resulted by net_pars()}

\item{randp}{random networks pars resulted by rand_net_par()}

\item{index}{compared indexes: "Average_path_length","Clustering_coefficient" or else}
}
\value{
ggplot
}
\description{
Net_pars of many random network

Compare some indexes between your net with random networks
}
\examples{
data("c_net")
rand_net_par(co_net_rmt, reps = 30) -> randp
net_par(co_net_rmt, fast = FALSE) -> pars
compare_rand(pars, randp)
}
\seealso{
Other topological: 
\code{\link{extract_sample_net}()},
\code{\link{fit_power}()},
\code{\link{get_group_skeleton}()},
\code{\link{links_stat}()},
\code{\link{nc}()},
\code{\link{net_par}()},
\code{\link{rand_net}()},
\code{\link{smallworldness}()}
}
\concept{topological}
