% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{pct_pval}
\alias{pct_pval}
\title{Return sign test p-value for meta-analysis percentile}
\usage{
pct_pval(yi, sei, mu, pct, R = 2000)
}
\arguments{
\item{yi}{Vector of study-level point estimates}

\item{sei}{Vector of study-level standard errors}

\item{mu}{The effect size to test as the \code{pct}^th percentile}

\item{pct}{The percentile of interest (e.g., 0.50 for the median)}

\item{R}{Number of simulation iterates to use when estimating null distribution of the test statistic.}
}
\description{
Returns a p-value for testing the hypothesis that \code{mu} is the \code{pct}^th
percentile of the true effect distribution based on the nonparametric sign test
method of Wang et al. (2010). This function is also called by \code{prop_stronger}
when using the sign test method.
}
\examples{
# calculate effect sizes for example dataset
d = metafor::escalc(measure="RR", ai=tpos, bi=tneg,
                   ci=cpos, di=cneg, data=metafor::dat.bcg)

# test H0: the median is -0.3
# using only R = 100 for speed, but should be much larger (e.g., 2000) in practice
pct_pval( yi = d$yi,
          sei = sqrt(d$vi),
          mu = -0.3,
          pct = 0.5,
          R = 100 )
}
\references{
1. Wang R, Tian L, Cai T, & Wei LJ (2010). Nonparametric inference procedure for percentiles
of the random effects distribution in meta-analysis. Annals of Applied Statistics.
}
