% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVPcaPls.R
\name{CVPcaPls}
\alias{CVPcaPls}
\title{Cross Validations for PCA and PLS based methods}
\usage{
CVPcaPls(Fold = 3, Survival, Mdata, Censor, Reduce = TRUE,
  Select = 15, Prognostic = NULL, Ncv = 5, DR = "PCA")
}
\arguments{
\item{Fold}{Number of times in which the dataset is divided. Default is 3 which implies dataset will be divided into three groups and 2/3 of the dataset will be the train datset and 1/3 will be to train the results.}

\item{Survival}{A vector of survival time with length equals to number of subjects}

\item{Mdata}{A large or small metabolic profile matrix. A matrix with metabolic profiles where the number of rows should be equal to the number of metabolites and number of columns should be equal to number of patients.}

\item{Censor}{A vector of censoring indicator}

\item{Reduce}{A boolean parameter indicating if the metabolic profile matrix should be reduced, default is TRUE and larger metabolic profile matrix is reduced by supervised pca approach and first pca is extracted from the reduced matrix to be used in the classifier.}

\item{Select}{Number of metabolites (default is 15) to be selected from supervised PCA. This is valid only if th argument Reduce=TRUE}

\item{Prognostic}{A dataframe containing possible prognostic(s) factor and/or treatment effect to be used in the model.}

\item{Ncv}{The Number of cross validation loop. Default is 50 but it is recommended to have at least 100.}

\item{DR}{The dimension reduction method. It can be either "PCA" for Principle components analysis or "PLS" for Partial least squares.}
}
\value{
A object of class \code{\link[MetabolicSurv]{cvpp}} is returned with the following values
  \item{Result}{A dataframe containg the estimated Hazard ratio of the test dataset and the training dataset}
 \item{Ncv}{The number of cross validation performed}
  \item{Method}{The dimesion reduction method used}
  \item{CVtrain}{The training dataset indices matrix used for the cross validation}
  \item{CVtest}{The test dataset indices matrix used for the cross validation}
\item{Select}{The number of metabolite used for the dimesion reduction method used}
}
\description{
This function does cross validation  for the analysis performs by \code{\link[MetabolicSurv]{SurvPcaClass}} and \code{\link[MetabolicSurv]{SurvPlsClass}} functions where the dimension reduction methods can either be PCA and PLS.
}
\details{
This function does cross validation for the analysis using two reduction method. The reduction method can be PCA or PLS. If it is PCA then the \code{\link[MetabolicSurv]{SurvPcaClass}} is internally used for the cross validation and \code{\link[MetabolicSurv]{SurvPlsClass}} otherwise.
}
\examples{
## FIRSTLY SIMULATING A METABOLIC SURVIVAL DATA
Data = MSData(nPatients = 100, nMet = 150, Prop = 0.5)

## USING THE FUNCTION
Result = CVPcaPls(Fold = 4, Survival = Data$Survival,
Mdata = t(Data$Mdata), Censor = Data$Censor, Reduce=TRUE,
Select=19, Prognostic= Data$Prognostic,Ncv=55,DR ="PLS")

## GET THE CLASS OF THE OBJECT
class(Result)     # An "cvpp" Class

##  METHOD THAT CAN BE USED FOR THE RESULT
show(Result)
summary(Result)
plot(Result)
}
\references{
\insertRef{ye1}{MetabolicSurv}

\insertRef{ye2}{MetabolicSurv}
}
\seealso{
\code{\link[MetabolicSurv]{SurvPlsClass}},
\code{\link[MetabolicSurv]{SurvPcaClass}}
}
\author{
Olajumoke Evangelina Owokotomo, \email{olajumoke.owokotomo@uhasselt.be}

Ziv Shkedy
}
