% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RestrictedPCA.R
\name{RestrictedPCA}
\alias{RestrictedPCA}
\title{RestrictedPCA.}
\usage{
RestrictedPCA(
  dat = NULL,
  sam = NULL,
  use.sam = NULL,
  group.col = NULL,
  text.col = NULL,
  fmod = NULL,
  sign.col = NULL,
  p.adjust.method = "none",
  P = 0.01,
  pcaMethods.scale = "pareto",
  n.metab.min = 20,
  ...
)
}
\arguments{
\item{dat}{Metabolite matrix (samples x metabolites).}

\item{sam}{Sample definition dataframe.}

\item{use.sam}{Numeric index vector (or logical) to select specific samples to be included in the analysis or NULL to include all.}

\item{group.col}{Column used for legend creation (column name from sam).}

\item{text.col}{Column used for text annotation of data points (column name from sam).}

\item{fmod}{ANOVA model to calculate before PCA.}

\item{sign.col}{Which column(s) of the ANOVA result shall be used for P-value filtering (specify column names or leave on NULL to filter on all).}

\item{p.adjust.method}{Method use to adjust P-values (e.g. none, BH or bonferroni).}

\item{P}{P-value threshold used as a cutoff after P-value adjustment.}

\item{pcaMethods.scale}{pcaMethods scale parameter (usually pareto for metabolite data).}

\item{n.metab.min}{Minimum number of metabolites kept for PCA calculation (even if they exceed P).}

\item{...}{Handed through to \code{\link{PlotMetabolitePCA}}.}
}
\value{
Will generate a PCA plot (generated by \link{PlotMetabolitePCA} internally)
  restricted based on an ANOVA result based on \link{MetaboliteANOVA}.
}
\description{
\code{RestrictedPCA} combines an ANOVA based on 'fmod' and
  restricts a PCA using the ANOVA result as a filter.
}
\details{
`fmod` should be something like 'GT*TR+Batch' to perform
  an ANOVA with these factors defined as columns in sam.
}
\examples{
# load raw data and sample description
raw <- MetabolomicsBasics::raw
sam <- MetabolomicsBasics::sam
# standard behavior
RestrictedPCA(dat = raw, sam = sam, group.col = "GT")
\dontrun{
# apply multiple testing using a strict P-value cutoff,
# dont show a legend but plot group mean values and sd's as overlay
RestrictedPCA(
  dat = raw, sam = sam, group.col = "GT", p.adjust.method = "BH", P = 10^-10,
  fmod = "GT+Batch+Order", sign.col = "GT", medsd = T, legend.x = NULL
)
# limit to a subset of samples, switching the ANOVA selection of by setting P=1
# and adding text (from \code{sam}) to each data point
RestrictedPCA(
  dat = raw, sam = sam, use.sam = which(sam$GT \%in\% c("Mo17", "B73")), group.col = "GT",
  fmod = "GT+Batch+Order", P = 1, sign.col = "GT", legend.x = NULL, text.col = "Batch"
)
}
}
