% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to.wide.R
\name{to.wide}
\alias{to.wide}
\title{Functions to convert between long and wide representations of data}
\usage{
to.wide(data, warn = TRUE)
}
\arguments{
\item{data}{A \code{\link{Meth}} object.}

\item{warn}{Logical. Should a warning be printed when replicates are taken as items?}
}
\value{
A data frame with the reshaped data
}
\description{
These functions are merely wrappers for \code{\link{reshape}}.
Given the complicated syntax of \code{reshape} and the particularly simple
structure of this problem, the functions facilitate the conversion
enormously.
}
\details{
If \code{data} represents method comparisons with exchangeable  replicates within method, the transformation to wide format does not necessarily make sense.
}
\examples{

data( milk )
str( milk )
mw <- to.wide( milk )
str( mw )
( mw <- subset( mw, as.integer(item) < 3 ) )
to.long( mw, 3:4 )

}
