% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_analysis.R
\name{fun_analysis}
\alias{fun_analysis}
\title{Analyzing function.}
\usage{
fun_analysis(
  msec,
  mut_depth,
  short_homology_search_length,
  min_homology_search,
  threshold_p,
  threshold_hairpin_ratio,
  threshold_soft_clip_ratio,
  threshold_short_length,
  threshold_distant_homology,
  threshold_low_quality_rate,
  homopolymer_length
)
}
\arguments{
\item{msec}{Mutation filtering information.}

\item{mut_depth}{Mutation coverage data.}

\item{short_homology_search_length}{Small sequence for homology search.}

\item{min_homology_search}{The sequence length for homology
search.}

\item{threshold_p}{The largest p value of significant errors.}

\item{threshold_hairpin_ratio}{The smallest hairpin read ratio.}

\item{threshold_soft_clip_ratio}{The smallest rate of significantly
soft-clipped reads.}

\item{threshold_short_length}{Reads shorter than that are analyzed.}

\item{threshold_distant_homology}{The smallest rate of reads from other
regions.}

\item{threshold_low_quality_rate}{The smallest rate of low quality bases.}

\item{homopolymer_length}{The smallest length of homopolymers.}
}
\value{
msec
}
\description{
This function analyzes the filtering results.
}
\examples{
fun_analysis(msec = msec_summarized,
             mut_depth = mut_depth_checked,
             short_homology_search_length = 4,
             min_homology_search = 40,
             threshold_p = 10 ^ (-6),
             threshold_hairpin_ratio = 0.50,
             threshold_soft_clip_ratio = 0.90,
             threshold_short_length = 0.8,
             threshold_distant_homology = 0.2,
             threshold_low_quality_rate = 0.1,
             homopolymer_length = 15)
}
