% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{SRS_curve_pq}
\alias{SRS_curve_pq}
\title{Scaling with ranked subsampling (SRS) curve of phyloseq object}
\usage{
SRS_curve_pq(physeq, clean_pq = FALSE, ...)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{clean_pq}{(logical): Does the phyloseq
object is cleaned using the \code{\link[=clean_pq]{clean_pq()}} function?}

\item{...}{Additional arguments passed on to \code{SRS::SRScurve()}}
}
\value{
A plot
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


A wraper of \code{\link[SRS:SRScurve]{SRS::SRScurve()}} function.
}
\examples{
if (requireNamespace("SRS")) {
  SRS_curve_pq(data_fungi_mini,
    max.sample.size = 200,
    rarefy.comparison = TRUE, rarefy.repeats = 3
  )
  SRS_curve_pq(data_fungi_mini, max.sample.size = 500, metric = "shannon")
}
}
