% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blast.R
\name{add_blast_info}
\alias{add_blast_info}
\title{Add information from \code{\link[=blast_pq]{blast_pq()}} to the \code{tax_table} slot of a \emph{phyloseq} object}
\usage{
add_blast_info(physeq, fasta_for_db, silent = FALSE, ...)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{fasta_for_db}{path to a fasta file to make the blast database}

\item{silent}{(logical) If true, no message are printing.}

\item{...}{Other arguments passed on to \code{\link[=blast_pq]{blast_pq()}} function.}
}
\value{
a physeq object with more information in tax_table based on a
blast on a given database
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Basically a wrapper of \code{\link[=blast_pq]{blast_pq()}} with option \code{unique_per_seq = TRUE} and
\code{score_filter = FALSE}.

Add the information to the taxtable
}
\author{
Adrien Taudière
}
