% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speedyseq_functions.R
\name{merge_taxa_vec}
\alias{merge_taxa_vec}
\alias{merge_taxa_vec,phyloseq-method}
\alias{merge_taxa_vec,otu_table-method}
\alias{merge_taxa_vec,taxonomyTable-method}
\alias{merge_taxa_vec,phylo-method}
\alias{merge_taxa_vec,XStringSet-method}
\title{Merge taxa in groups (vectorized version)}
\usage{
merge_taxa_vec(x, group, reorder = FALSE, tax_adjust = 1L)

\S4method{merge_taxa_vec}{phyloseq}(x, group, reorder = FALSE, tax_adjust = 1L)

\S4method{merge_taxa_vec}{otu_table}(x, group, reorder = FALSE)

\S4method{merge_taxa_vec}{taxonomyTable}(x, group, reorder = FALSE, tax_adjust = 1L)

\S4method{merge_taxa_vec}{phylo}(x, group)

\S4method{merge_taxa_vec}{XStringSet}(x, group, reorder = FALSE)
}
\arguments{
\item{x}{A phyloseq object or component object}

\item{group}{A vector with one element for each taxon in \code{physeq} that
defines the new groups. see \code{base::rowsum()}.}

\item{reorder}{Logical specifying whether to reorder the taxa by their
\code{group} values. Ignored if \code{x} has (or is) a phylogenetic tree.}

\item{tax_adjust}{0: no adjustment; 1: phyloseq-compatible adjustment; 2:
conservative adjustment}
}
\value{
A new phyloseq-class, otu_table, tax_table, XStringset or
sam_data object depending on the class of the x param
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Firstly release in the \href{https://github.com/mikemc/speedyseq/}{speedyseq} R
package by Michael R. McLaren.

Merge taxa in \code{x} into a smaller set of taxa defined by the vector \code{group}.
Taxa whose value in \code{group} is NA will be dropped. New taxa will be named
according to the most abundant taxon in each group (\code{phyloseq} and
\code{otu_table} objects) or the first taxon in each group (all other phyloseq
component objects).

If \code{x} is a phyloseq object with a phylogenetic tree, then the new taxa will
be ordered as they are in the tree. Otherwise, the taxa order can be
controlled by the \code{reorder} argument, which behaves like the \code{reorder}
argument in \code{\link[base:rowsum]{base::rowsum()}}. \code{reorder = FALSE} will keep taxa in
the original order determined by when the member of each group first appears
in \code{taxa_names(x)}; \code{reorder = TRUE} will order new taxa according to their
corresponding value in \code{group}.

The \code{tax_adjust} argument controls the handling of taxonomic disagreements
within groups. Setting \code{tax_adjust == 0} causes no adjustment; the taxonomy
of the new group is set to the archetype taxon (see below). Otherwise,
disagreements within a group at a given rank cause the values at lower ranks
to be set to \code{NA}. If \code{tax_adjust == 1} (the default), then a rank where all
taxa in the group are already NA is not counted as a disagreement, and lower
ranks may be kept if the taxa agree. This corresponds to the original
phyloseq behavior. If \code{tax_adjust == 2}, then these NAs are treated as a
disagreement; all ranks are set to NA after the first disagreement or NA.
}
\seealso{
Function in MiscMetabar that use this function: \code{\link[=asv2otu]{asv2otu()}}

\code{\link[base:rowsum]{base::rowsum()}}

\code{\link[phyloseq:merge_taxa-methods]{phyloseq::merge_taxa()}}
}
\author{
Michael R. McLaren (orcid: \href{https://orcid.org/0000-0003-1575-473X}{0000-0003-1575-473X}) modified by Adrien Taudiere
}
