% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mphd.R
\name{mixMPHD}
\alias{mixMPHD}
\title{Semiparametric Mixture Model by Minimizing Profile Hellinger Distance}
\usage{
mixMPHD(x, sigma.known = NULL, ini = NULL)
}
\arguments{
\item{x}{a vector of observations.}

\item{sigma.known}{standard deviation of one component (if known). Default is NULL.}

\item{ini}{initial values for the parameters. Default is NULL, which obtains the initial values
using the \code{\link{mixOnekn}} function. It can be a list with the form of \code{list(mu, pi, sigma)}, where
\code{mu} is a vector of component means,
\code{pi} is a vector of component mixing proportions,
\code{sigma} is a vector of component standard deviations.}
}
\value{
A list containing the following elements:
\item{lik}{final likelihood.}
\item{pi}{estimated mixing proportion.}
\item{sigma}{estimated component standard deviation. Only returned when \code{sigma.known} is not provided.}
\item{mu}{estimated component mean.}
\item{run}{total number of iterations after convergence.}
}
\description{
`mixMPHD' provides an efficient and robust estimation of a mixture of unknown
location-shifted symmetric distributions using a semiparamatric method (Wu et al., 2017).
As of version 1.1.0, 'mixMPHD' supports a two-component model, which is defined as
\deqn{h(x;\boldsymbol{\theta},f) = \pi f(x-\mu_1)+(1-\pi)f(x-\mu_2),}
where \eqn{\boldsymbol{\theta}=(\pi,\mu_1,\mu_2)^{\top}} is the parameter to estimate,
\eqn{f} is an unknown density function that is symmetric at zero.
The parameters are estimated by minimizing the profile Hellinger distance (MPHD)
between the parametric model and a non-parametric density estimate.
}
\examples{
# Model: X ~ 0.3*N(0, 1) + 0.7*N(3, 1)
set.seed(4)
n = 100
p = 0.3
n1 = rbinom(1, n, p)
sigma1 = 1
sigma2 = 1
x1 = rnorm(n1, mean = 0, sd = sigma1)
x2 = rnorm(n - n1, mean = 3, sd = sigma2)
x = c(x1, x2)
ini = mixOnekn(x, sigma1)
mixMPHDest = mixMPHD(x, sigma1, ini = ini)
}
\references{
Wu, J., Yao, W., and Xiang, S. (2017). Computation of an efficient and robust estimator
in a semiparametric mixture model. Journal of Statistical Computation and Simulation, 87(11), 2128-2137.
}
\seealso{
\code{\link{mixOnekn}} for initial value calculation.
}
