% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/joint.R
\name{coefExpJointCDF}
\alias{coefExpJointCDF}
\title{Degree Function}
\usage{
coefExpJointCDF(dimensions)
}
\arguments{
\item{dimensions}{A \code{"numeric"} vector including the number of parameters of each variable.}
}
\value{
A list with n element. Each element contains a \code{numeric} vector with the degree for
each variable and each term of the cumulative joint function.
}
\description{
Compute the degree for each term of a cumulative joint function.
}
\examples{
## Dimension of the joint PDF of 2 variables
dim <- c(4,5)
## Potentials of each term of the CDF
c <- coefExpJointCDF(dim)
length(c) + 1 ## prod(dim+1) ## plus 1 because of the constant coefficient

## Dimension of the joint density function of 2 variables
dim <- c(5,5,3)
## Potentials of the cumulative function
coefExpJointCDF(dim)
}

