% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/motbf.R
\name{derivMoTBF}
\alias{derivMoTBF}
\title{Derivative MoTBF}
\usage{
derivMoTBF(fx)
}
\arguments{
\item{fx}{An object of \code{"motbf"} class.}
}
\value{
The derivative which is also an \code{"motbf"} function.
}
\description{
Compute derivatives of \code{"motbf"} objects.
}
\examples{
## 1. EXAMPLE
X <- rexp(1000)
Px <- univMoTBF(X, POTENTIAL_TYPE="MOP")
derivMoTBF(Px)

## 2. EXAMPLE
X <- rnorm(1000)
Px <- univMoTBF(X, POTENTIAL_TYPE="MOP")
derivMoTBF(Px)

## 3. EXAMPLE
X <- rchisq(1000, df = 3)
Px <- univMoTBF(X, POTENTIAL_TYPE="MTE")
derivMoTBF(Px)

## 4. EXAMPLE
Px <- "x+2"
class(Px)
derivMoTBF(Px)
## Message: "It is not an 'motbf' function."
}
\seealso{
\link{univMoTBF}, \link{derivMOP} and \link{derivMTE}
}

