% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mop.R
\name{mop.learning}
\alias{mop.learning}
\alias{bestMOP}
\title{Fitting Polynomial Models}
\usage{
mop.learning(X, nparam, domain)

bestMOP(X, domain, maxParam = NULL)
}
\arguments{
\item{X}{A \code{"numeric"} data vector.}

\item{nparam}{Number of parameters of the function.}

\item{domain}{A \code{"numeric"} containing the range where defining the function.}

\item{maxParam}{A \code{"numeric"} value which indicate the maximum number of coefficients in the function. By default it is \code{NULL}; 
if not, the output is the function which gets the best BIC with at most this number of parameters.}
}
\value{
\code{mop.lerning()} returns a list of n elements:
\item{Function}{An \code{"motbf"} object of the \code{'mop'} subclass.}
\item{Subclass}{\code{'mop'}.}
\item{Domain}{The range where the function is defined to be a legal density function.}
\item{Iterations}{The number of iterations that the optimization problem needs to minimize
the errors.}
\item{Time}{The time which spend the CPU for solving the problem.}

\code{bestMOP()} returns a list including the polynomial function with the best BIC score, 
the number of parameters, the best BIC value and an array contained 
the BIC values of the evaluated functions.
}
\description{
These functions fit mixtures of polynomials (MOPs).  
Least square optimization is used to  
minimize the quadratic error between the empirical 
cumulative distribution and the estimated one.
}
\details{
\code{mop.learning()}:
The returned value \code{$Function} is the only visible element which contains the mathematical expression. 
Using \link{attributes} the name of the others elements are shown and also they can be abstract with \code{$}.
The \link{summary} of the function also shows all this elements.

\code{bestMOP()}:
The first returned value \code{$bestPx} contains the output of the \code{mop.learning()} function
with the number of parameters which gets the best BIC values, taking into account the  
Bayesian information criterion (BIC) to penalize the functions. It evaluates the two next functions,
if the BIC doesn't improve then the function with the last best BIC is returned.
}
\examples{
## 1. EXAMPLE 
data <- rnorm(1000)

## MOP with fix number of degrees
fx <- mop.learning(data, nparam=7, domain=range(data))
fx
hist(data, prob=TRUE, main="")
plot(fx, col=2, xlim=range(data), add=TRUE)

## Best MOP in terms of BIC
fMOP <- bestMOP(data, domain=range(data))
attributes(fMOP)
fMOP$bestPx
hist(data, prob=TRUE, main="")
plot(fMOP$bestPx, col=2, xlim=range(data), add=TRUE)

## 2. EXAMPLE
data <- rbeta(4000, shape1=1/2, shape2=1/2)

## MOP with fix number of degrees 
fx <- mop.learning(data, nparam=6, domain=range(data))
fx
hist(data, prob=TRUE, main="")
plot(fx, col=2, xlim=range(data), add=TRUE)

## Best MOP in terms of BIC
fMOP <- bestMOP(data, domain=range(data), maxParam=6)
attributes(fMOP)
fMOP$bestPx
attributes(fMOP$bestPx)
hist(data, prob=TRUE, main="")
plot(fMOP$bestPx, col=2, xlim=range(data), add=TRUE)
}
\seealso{
\link{univMoTBF} A complete function for learning MOPs which includes extra options.
}
